/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart;

import java.awt.Graphics;
import java.awt.Point;
import java.io.Serializable;
import java.util.Vector;
import jclass.chart.ChartDataView;
import jclass.chart.ChartDataViewSeries;
import jclass.chart.Drawable;
import jclass.chart.JCAxis;
import jclass.chart.JCChartArea;
import jclass.chart.JCChartBundle;
import jclass.chart.JCDataIndex;
import jclass.chart.JCLineStyle;
import jclass.chart.MinMax;
import jclass.chart.PlotPoint;
import jclass.chart.TrackChange;

abstract class ChartDraw
extends TrackChange
implements Drawable,
Serializable {
    ChartDataViewSeries[] seriesList;
    boolean inverted = false;
    double holeValue = Double.MAX_VALUE;
    boolean fastUpdate = false;
    boolean cachePlotData = true;
    JCAxis xaxis;
    JCAxis yaxis;
    int chartType = -1;
    ChartDataView dataObject;
    JCChartArea chartArea;
    int numActiveDataSeries;
    boolean drawFront = true;
    public static String[] drawables = new String[]{"PlotChartDraw", "PlotChartDraw", "PolarChartDraw", "RadarChartDraw", "RadarChartDraw", "HiloChartDraw", "HLOCChartDraw", "CandleChartDraw", "AreaChartDraw", "BarChartDraw", "SBarChartDraw", "PieChartDraw"};
    public static final int BASE_MARGIN = 10;
    public static final int NUM_SERIES_PER_DATA = 1;
    static final int TROUGH_NOT_DRAWN = 0;
    static final int TROUGH_DRAWN = 1;
    static final int FINISH_TROUGH_LATER = 2;

    public ChartDraw() {
    }

    public void setDataView(ChartDataView chartDataView) {
        this.dataObject = chartDataView;
        this.chartArea = chartDataView.chart.chartArea;
        if (this.dataObject != null) {
            this.chartType = this.dataObject.getChartType();
        }
    }

    public ChartDraw(ChartDataView chartDataView) {
        this.setDataView(chartDataView);
    }

    public static ChartDraw makeDrawObject(ChartDataView chartDataView) {
        ChartDraw chartDraw = null;
        try {
            chartDraw = (ChartDraw)Class.forName("jclass.chart." + drawables[chartDataView.getChartType()]).newInstance();
        }
        catch (Throwable throwable) {
            System.out.println(String.valueOf(JCChartBundle.string("jclass.chart.Key19")) + chartDataView.getChartType());
            chartDraw = null;
        }
        if (chartDraw != null) {
            chartDraw.setDataView(chartDataView);
        }
        return chartDraw;
    }

    public void recalc() {
        this.numActiveDataSeries = 0;
        ChartDataViewSeries[] chartDataViewSeriesArray = this.dataObject.getSeries();
        if (chartDataViewSeriesArray == null || chartDataViewSeriesArray.length == 0) {
            return;
        }
        int n = 0;
        while (n < chartDataViewSeriesArray.length) {
            if (chartDataViewSeriesArray[n].getIsShowing()) {
                ++this.numActiveDataSeries;
            }
            ++n;
        }
        if (this.chartArea == null || !this.chartArea.draw3D || this.dataObject.is3DChartType() || this.dataObject.xaxis.frontPlane && this.dataObject.yaxis.frontPlane && this.dataObject.drawFrontPlane) {
            this.drawFront = true;
            return;
        }
        this.drawFront = false;
    }

    public void recalc(int n, int n2) {
    }

    public void draw(Graphics graphics, int n, int n2) {
    }

    public void setChanged(boolean bl, int n) {
        super.setChanged(bl, n);
        if (!this.changed && this.dataObject != null) {
            this.dataObject.setChanged(false, 0, false);
        }
    }

    public void setChanged(boolean bl, int n, boolean bl2) {
        if (bl2) {
            this.setChanged(bl, n);
            return;
        }
        this.changed = bl;
        if (!this.changed && this.dataObject != null) {
            this.dataObject.setChanged(false, 0, false);
        }
    }

    protected void calcTransientData() {
    }

    JCDataIndex pick(Point point, int n) {
        return null;
    }

    Point unpick(int n, int n2) {
        return null;
    }

    void startEdit(JCDataIndex jCDataIndex) {
    }

    void showEdit(JCDataIndex jCDataIndex, int n, int n2) {
    }

    int endEdit(JCDataIndex jCDataIndex, int n, int n2) {
        return -1;
    }

    int getNumSeriesPerData() {
        return 1;
    }

    void financialClip(double d, double d2, double d3, double d4, MinMax minMax, MinMax minMax2, PlotPoint[] plotPointArray, int n, int n2, boolean bl, boolean bl2) {
        boolean bl3;
        double d5 = minMax.min;
        double d6 = minMax.max;
        double d7 = minMax2.min;
        double d8 = minMax2.max;
        JCAxis jCAxis = this.dataObject.getXAxis();
        JCAxis jCAxis2 = this.dataObject.getYAxis();
        boolean bl4 = true;
        boolean bl5 = true;
        if (d2 == this.dataObject.holeValue || d == this.dataObject.holeValue || d4 == this.dataObject.holeValue || d3 == this.dataObject.holeValue) {
            return;
        }
        boolean bl6 = d == d3;
        boolean bl7 = bl3 = d2 == d4;
        if (!bl6 && !bl3) {
            return;
        }
        if ((d2 < d7 && d4 < d7 || d2 > d8 && d4 > d8) && (!bl3 || !bl2)) {
            return;
        }
        if (d2 < d7) {
            d2 = d7;
            bl4 = false;
        } else if (d2 > d8) {
            d2 = d8;
            bl4 = false;
        }
        if (d4 < d7) {
            d4 = d7;
            bl5 = false;
        } else if (d4 > d8) {
            d4 = d8;
            bl5 = false;
        }
        if (d < d5 && d3 < d5 || d > d6 && d3 > d6) {
            return;
        }
        if (d < d5) {
            d = d5;
            bl4 = false;
        } else if (d > d6) {
            d = d6;
            bl4 = false;
        }
        if (d3 < d5) {
            d3 = d5;
            bl5 = false;
        } else if (d3 > d6) {
            d3 = d6;
            bl5 = false;
        }
        this.addClippedPoint(null, plotPointArray, n2, d, d2, jCAxis, jCAxis2, bl, bl4, n);
        this.addClippedPoint(null, plotPointArray, n2 + 1, d3, d4, jCAxis, jCAxis2, bl, bl5, n);
    }

    void addClippedPoint(Vector vector, PlotPoint[] plotPointArray, int n, double d, double d2, JCAxis jCAxis, JCAxis jCAxis2, boolean bl, boolean bl2, int n2) {
        PlotPoint plotPoint = new PlotPoint();
        if (bl) {
            plotPoint.px = jCAxis2.toPixel(d2, this.drawFront);
            plotPoint.py = jCAxis.toPixel(d, this.drawFront);
        } else {
            plotPoint.px = jCAxis.toPixel(d, this.drawFront);
            plotPoint.py = jCAxis2.toPixel(d2, this.drawFront);
        }
        plotPoint.drawPoint = bl2;
        plotPoint.point = n2;
        if (plotPointArray != null) {
            plotPointArray[n] = plotPoint;
        }
        if (vector != null) {
            vector.addElement(plotPoint);
        }
    }

    int tryDrawYAxisTroughGrid(Graphics graphics, int n, int n2, JCAxis jCAxis, int n3, int n4) {
        boolean bl = false;
        boolean bl2 = false;
        if (!this.inverted && n > 0 || this.inverted && n2 > 0) {
            if (n3 > jCAxis.linePosition()) {
                if (jCAxis.gridIsShowing) {
                    jCAxis.drawGridInTrough(graphics, Double.MAX_VALUE, Double.MAX_VALUE);
                }
                jCAxis.postDrawOutlineTrough(graphics, 3);
                bl = true;
            } else if (n4 > jCAxis.linePosition()) {
                if (jCAxis.gridIsShowing) {
                    jCAxis.drawGridInTrough(graphics, Double.MAX_VALUE, Double.MAX_VALUE);
                }
                bl2 = true;
                bl = true;
            }
        } else if (n4 < jCAxis.linePosition()) {
            if (jCAxis.gridIsShowing) {
                jCAxis.drawGridInTrough(graphics, Double.MAX_VALUE, Double.MAX_VALUE);
            }
            jCAxis.postDrawOutlineTrough(graphics, 3);
            bl = true;
        } else if (n3 < jCAxis.linePosition()) {
            if (jCAxis.gridIsShowing) {
                jCAxis.drawGridInTrough(graphics, Double.MAX_VALUE, Double.MAX_VALUE);
            }
            bl2 = true;
            bl = true;
        }
        if (bl2) {
            return 2;
        }
        if (bl) {
            return 1;
        }
        return 0;
    }

    void finishDrawYAxisTroughGrid(Graphics graphics, int n, int n2, JCAxis jCAxis, int n3, double d, double d2) {
        if (!this.inverted && n3 == 0 && n2 >= 0 || !this.inverted && n3 == 1 && n2 < 0 || this.inverted && n3 == 0 && n < 0 || this.inverted && n3 == 1 && n >= 0) {
            if (jCAxis.gridIsShowing) {
                jCAxis.drawGridInTrough(graphics, -1.7976931348623157E308, Math.min(d, d2));
            }
            jCAxis.postDrawOutlineTrough(graphics, 2);
            return;
        }
        if (jCAxis.gridIsShowing) {
            jCAxis.drawGridInTrough(graphics, Math.max(d2, d), Double.MAX_VALUE);
        }
        jCAxis.postDrawOutlineTrough(graphics, 1);
    }

    /*
     * Unable to fully structure code
     */
    int drawXAxisTroughGrid(Graphics var1_1, int var2_2, int var3_3, JCAxis var4_4, int var5_5, double var6_6, int var8_7, int var9_8, double var10_9, double var12_10, double[] var14_11, int var15_12, int var16_13, JCLineStyle var17_14) {
        block11: {
            var18_15 = false;
            if (this.inverted == false && var5_5 == 0 && var3_3 <= 0 || this.inverted == false && var5_5 != 0 && var3_3 > 0 || this.inverted != false && var5_5 == 0 && var2_2 > 0 || this.inverted && var5_5 != 0 && var2_2 <= 0) {
                if (var6_6 >= var12_10 && var6_6 >= var10_9) {
                    var18_15 = true;
                }
            } else if (var6_6 <= var12_10 && var6_6 <= var10_9) {
                var18_15 = true;
            }
            if (!this.inverted && var2_2 > 0 || this.inverted && var3_3 > 0) {
                var19_16 = var8_7;
                var20_17 = var9_8;
            } else {
                var19_16 = var9_8;
                var20_17 = var8_7;
            }
            var21_18 = var16_13 == 1 ? var4_4.getMin() : var4_4.getMax();
            while (var15_12 >= 0 && var15_12 < var14_11.length && var14_11[var15_12] == 1.7976931348623157E308) {
                var15_12 += var16_13;
            }
            if ((this.inverted || var2_2 <= 0) && (!this.inverted || var3_3 <= 0)) ** GOTO lbl28
            while (var15_12 >= 0 && var15_12 < var14_11.length && var4_4.toPixel(var14_11[var15_12], this.drawFront) <= (var18_15 != false ? var19_16 : var20_17)) {
                if (var14_11[var15_12] != var21_18) {
                    var4_4.drawGridLineInTrough(var1_1, var17_14, var14_11[var15_12]);
                }
                var15_12 += var16_13;
            }
            break block11;
lbl-1000:
            // 1 sources

            {
                if (var14_11[var15_12] != var21_18) {
                    var4_4.drawGridLineInTrough(var1_1, var17_14, var14_11[var15_12]);
                }
                var15_12 += var16_13;
lbl28:
                // 2 sources

                ** while (var15_12 >= 0 && var15_12 < var14_11.length && var4_4.toPixel((double)var14_11[var15_12], (boolean)this.drawFront) > (var18_15 != false ? var19_16 : var20_17))
            }
        }
        return var15_12;
    }

    void finalDrawAxisTroughGrid(Graphics graphics, JCAxis jCAxis, JCAxis jCAxis2, int n, boolean bl, double[] dArray, int n2, int n3, JCLineStyle jCLineStyle) {
        if (!bl && jCAxis2.gridIsShowing) {
            jCAxis2.drawGridInTrough(graphics, Double.MAX_VALUE, Double.MAX_VALUE);
        }
        if (jCAxis.gridIsShowing) {
            while (n2 >= 0 && n2 < dArray.length && dArray[n2] == Double.MAX_VALUE) {
                n2 += n3;
            }
            while (n2 >= 0 && n2 < dArray.length) {
                jCAxis.drawGridLineInTrough(graphics, jCLineStyle, dArray[n2]);
                n2 += n3;
            }
        }
        if (!bl) {
            jCAxis2.postDrawOutlineTrough(graphics, 3);
        }
        if (n == 0) {
            jCAxis.postDrawOutlineTrough(graphics, 2);
            return;
        }
        jCAxis.postDrawOutlineTrough(graphics, 1);
    }

    public abstract void draw(Graphics var1);
}

